%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MATLAB code: Example 10.4; Figure 10.4
% File: ExpAR_LMforecast.m
%
% LINEARIZATION METHOD (LM) FORECASTS FROM AN ExpAR(1) MODEL:
% mu(X;theta) = {\phi + \xi \exp(-\gamma X^{2})}X
%
% SKELETON (SK)
% Normal forecast error (NFE)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

a      = 0.8;   % \phi
b      = 0.3;   % \xi
c      = 1;     % \gamma 
sigma2 = 0.01;  % figure 10.4(b) or sigma2=1 as in Figure 10.4(a) 
sigma  = sqrt(sigma2);

xlim   = sqrt(log(b/(1-a)));    % \pm limiting points

%%%%   Initialization  %%%%%%%%%%
xx(1) = 1;                                 % starting point  
x(1)  = (a+b*exp(-c*xx(1)*xx(1)))*xx(1);   % One step ahead forecast % LINEARIZATION

xsk(1)   = x(1);    % 0.555;   SKELETON  one step ahead
xn(1)    = x(1);    %          NFE       one step ahead
sig(1)   = sigma2;  % note squared value 
sn(1)    = sigma2;
index(1) = 1;

f(1) = 1 + 2*c*sig(1)*(2*c*x(1)*x(1)-3);
y(1) = x(1);
r    = normrnd(0,sigma,1,51); 

for i=1:49
    y(i+1) = (a+b*exp(-c*y(i)*y(i)))*y(i)+r(i+1);
end

%%%%%%%%%  Linearization method (LM) %%%%%%%%%%%%
for h=1:49
    f(h)       = 1 + 2*c*sig(h)*(2*c*x(h)*x(h)-3);   
    x(h+1)     = (a+b*f(h)*exp(-c*x(h)*x(h)))*x(h);
    sig(h+1)   = sigma2 + sig(h)*(a+b*(1-2*x(h)*x(h))*exp(-x(h)*x(h)))^2;
    index(h+1) = h+1;
end

plot(index,y,'-',index,x,'--') 
%% hold on

%%%%%%%%% Skeleton method  %%%%%%%%%%%%%%%%%
for h=1:49
    xsk(h+1) = (a+b*exp(-c*xsk(h)*xsk(h)))*xsk(h);
end

plot(index,y,'-',index,xsk,'--') 
%% hold on

%%%%%%%%%  Normal forecast error  (NFE) %%%%%%%%%%%%%%
for h=1:49
    ah(h) = 1 + 2*c*sn(h);
    bh(h) = b*(ah(h))^(-1.5);
    ch(h) = c*(ah(h))^(-1);
    B(h)  = 1 + 4*c*sn(h);
    D(h)  = 2*c*(B(h))^(-1);
    
    xn(h+1) = (a+bh(h)*exp(-ch(h)*xn(h)*xn(h)))*xn(h);
    
    uu(h)   = sn(h)*(ah(h))^(-1.5)*(1-2*ch(h)*xn(h)*xn(h))*exp(-ch(h)*xn(h)*xn(h));
    vv(h)   = (B(h))^(-1.5)*(sn(h)+(B(h))^(-1)*xn(h)*xn(h))*exp(-D(h)*xn(h)*xn(h))...
              -(ah(h))^(-3)*xn(h)*xn(h)*exp(-2*ch(h)*xn(h)*xn(h));
    
    sn(h+1) = a*a*sn(h)+sigma2+b*b*vv(h)+2*a*b*uu(h);
end

plot(index,y,'-',index,xn,'--',index,xsk,':',index,x,'r+')
hold off




